/*
 * BeliefPropagation.h
 *
 *  Created on: Dec 12, 2013
 *      Author: nino
 */

#ifndef BELIEFPROPAGATION_H_
#define BELIEFPROPAGATION_H_

#include <StandardLibs.h>
#include <NetworkStructure.h>

void DMP_algorithm(double p, double q, infected_structure * p_infected_parameters, int T_value, igraph_vector_t * prob_inf_DMP);

void initial_conditions_DMP(igraph_spmatrix_t * Theta_now, igraph_spmatrix_t * Phi_now, igraph_vector_t *prob_I_now, infected_structure * p_infected_parameters);

void update_P_S_DMP(igraph_spmatrix_t * P_S_next, igraph_spmatrix_t * Theta_next, infected_structure * p_infected_parameters);

void update_theta_DMP(double p, igraph_spmatrix_t * Theta_next, igraph_spmatrix_t * Theta_now, igraph_spmatrix_t* Phi_now, infected_structure * p_infected_parameters);

void update_marginal_prob_S_DMP(igraph_vector_t *prob_S_next, igraph_spmatrix_t *Theta_next, infected_structure *p_infected_parameters);

void update_marginal_prob_R_DMP(double q, igraph_vector_t *prob_R_next, igraph_vector_t *prob_R_now, igraph_vector_t *prob_I_now);

void update_marginal_prob_I_DMP(igraph_vector_t *prob_S_next, igraph_vector_t *prob_I_next, igraph_vector_t *prob_R_next);

void update_phi_DMP(double p, double q, igraph_spmatrix_t * Phi_now, igraph_spmatrix_t * Phi_last, igraph_spmatrix_t* P_S_now, igraph_spmatrix_t* P_S_last, infected_structure * p_infected_parameters);

#endif /* BELIEFPROPAGATION_H_ */
